﻿Imports System.Data.SqlClient
Public Class frmNewPayment
    Dim gridCount As Integer
    Dim paiedAmount As String
    Dim grnNumber(500), splrCode(500), grnCode As String
    Dim addPayDs, addPaymentDs As New DataSet
    Dim addPayDa, addPaymentDa As SqlDataAdapter
    Dim result As MsgBoxResult

    Private Sub frmNewPayment_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Db_Connection()
            LoadGrnNumber()
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadGrnNumber()
        Try
            addPayDs.Reset()
            sql = " SELECT GRN_SPLRCODE, GRN_CODE FROM GRN WHERE IS_DELETE = 0 "
            addPayDa = New SqlDataAdapter(sql, Mycn)
            addPayDa.Fill(addPayDs, DBNAME)
            Dim rowCount = addPayDs.Tables(DBNAME).Rows.Count
            cmbGrnNumber.Items.Clear()
            For i = 0 To rowCount - 1
                splrCode(i) = addPayDs.Tables(DBNAME).Rows(i).Item(0)
                grnNumber(i) = addPayDs.Tables(DBNAME).Rows(i).Item(1)
                cmbGrnNumber.Items.Add(addPayDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub GridPaymentDisplay()
        Try
            addPaymentDs.Reset()
            sql = "SELECT  A.PMN_DATE, A.PMN_GRNNO, B.SPL_COMPNAME, A.PMN_PAYMENTTYPE, A.PMN_TRANSNO, A.PMN_TOTAMOUNT, A.PMN_PAIED_AMOUNT, A.PMN_PENDING_AMOUNT FROM PAYMENT_MASTER AS A LEFT JOIN SUPPLIER_MASTER AS B ON A.PMN_SPLRID = B.SPL_SPLCODE WHERE A.IS_DELETE = 0 AND A.PMN_GRNNO = '" & cmbGrnNumber.Text & "'"
            addPaymentDa = New SqlDataAdapter(sql, Mycn)
            addPaymentDa.Fill(addPaymentDs, DBNAME)
            dgvPayment.DataSource = addPaymentDs.Tables(DBNAME)
            dgvPayment.Columns(0).HeaderText = "Date"
            dgvPayment.Columns(1).HeaderText = "GRN NO"
            dgvPayment.Columns(2).HeaderText = "Supplier Name"
            dgvPayment.Columns(3).HeaderText = "Payment Type"
            dgvPayment.Columns(4).HeaderText = "Transaction No "
            dgvPayment.Columns(5).HeaderText = "Total Amount"
            dgvPayment.Columns(6).HeaderText = "Paied Amount"
            dgvPayment.Columns(7).HeaderText = "Pending Amount"
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadSupplier()
        Try
            addPayDs.Reset()
            sql = "SELECT A.SPL_COMPNAME FROM SUPPLIER_MASTER AS A LEFT JOIN GRN AS B ON A.SPL_SPLCODE = B.GRN_SPLRCODE WHERE GRN_CODE = '" & grnNumber(cmbGrnNumber.SelectedIndex) & "' AND B.IS_DELETE = 0 "
            addPayDa = New SqlDataAdapter(sql, Mycn)
            addPayDa.Fill(addPayDs, DBNAME)
            Dim rowCount = addPayDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                txtSuplierName.Text = addPayDs.Tables(DBNAME).Rows(0).Item(0)
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub cmbGrnNumber_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbGrnNumber.SelectedIndexChanged
        Try
            LoadSupplier()
            GridPaymentDisplay()
            addPayDs.Reset()
            sql = "SELECT SUM(PMH_AMOUNT) FROM PAYMENT_HISTORY WHERE PMH_GRN_NO = '" & grnNumber(cmbGrnNumber.SelectedIndex) & "' AND IS_DELETE = 0 "
            addPayDa = New SqlDataAdapter(sql, Mycn)
            addPayDa.Fill(addPayDs, DBNAME)
            Dim rowCount = addPayDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                txtTotalAmount.Text = addPayDs.Tables(DBNAME).Rows(0).Item(0).ToString
            End If

            addPayDs.Reset()
            sql = "SELECT PMN_GRNNO, SUM(PMN_PAIED_AMOUNT) FROM PAYMENT_MASTER WHERE IS_DELETE = 0 AND PMN_GRNNO = '" & cmbGrnNumber.Text & "' GROUP BY PMN_GRNNO"
            addPayDa = New SqlDataAdapter(sql, Mycn)
            addPayDa.Fill(addPayDs, DBNAME)
            Dim rowCount1 = addPayDs.Tables(DBNAME).Rows.Count
            If rowCount1 > 0 Then
                grnCode = addPayDs.Tables(DBNAME).Rows(0).Item(0).ToString
                txtPaiedAmount.Text = addPayDs.Tables(DBNAME).Rows(0).Item(1).ToString
            Else
                txtPaiedAmount.Text = "0.0"
            End If
            txtPendingAmount.Text = (txtTotalAmount.Text - txtPaiedAmount.Text)
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        Try
            If Trim(cmbGrnNumber.Text) <> "" And Trim(txtAmount.Text) <> "" And Trim(cmbPaymentType.Text) <> "" Then
                result = MsgBox("Are Sure you want add new Payment, Payment Details Not Editable", MsgBoxStyle.OkCancel)
                If result = MsgBoxResult.Ok Then
                    If txtTotalAmount.Text <> txtPaiedAmount.Text Then
                        paiedAmount = Val(Val(txtAmount.Text) + Val(txtPaiedAmount.Text))
                        addPaymentDs.Reset()
                        sql = " SELECT PMN_DATE, PMN_SPLRID, PMN_GRNNO, PMN_PAYMENTTYPE, PMN_TRANSNO, PMN_TOTAMOUNT, PMN_PAIED_AMOUNT, PMN_PENDING_AMOUNT, CREATED_DATE FROM PAYMENT_MASTER WHERE IS_DELETE = 0 "
                        addPaymentDa = New SqlDataAdapter(sql, Mycn)
                        addPaymentDa.Fill(addPaymentDs, DBNAME)

                        Dim cb As New SqlCommandBuilder(addPaymentDa)
                        Dim dsNewRow As DataRow
                        dsNewRow = addPaymentDs.Tables(DBNAME).NewRow()
                        dsNewRow.Item("PMN_DATE") = Now.ToString("MM/dd/yyyy")
                        dsNewRow.Item("PMN_GRNNO") = cmbGrnNumber.Text
                        dsNewRow.Item("PMN_SPLRID") = splrCode(cmbGrnNumber.SelectedIndex)
                        dsNewRow.Item("PMN_PAYMENTTYPE") = cmbPaymentType.Text
                        dsNewRow.Item("PMN_TRANSNO") = txtTransactionNo.Text
                        dsNewRow.Item("PMN_TOTAMOUNT") = txtTotalAmount.Text
                        dsNewRow.Item("PMN_PAIED_AMOUNT") = txtAmount.Text
                        dsNewRow.Item("PMN_PENDING_AMOUNT") = Val(Val(txtTotalAmount.Text) - paiedAmount)
                        dsNewRow.Item("CREATED_DATE") = Now.ToString("MM/dd/yyyy")
                        addPaymentDs.Tables(DBNAME).Rows.Add(dsNewRow)
                        addPaymentDa.Update(addPaymentDs, DBNAME)
                        paiedAmount = "0"
                        FieldClear()
                        GridPaymentDisplay()
                        MsgBox("Payment Added")
                        LoadGrnNumber()
                    Else
                        MsgBox("No Pending Amount")
                        FieldClear()
                    End If
                Else
                    MsgBox("No Payment Added")
                    FieldClear()
                End If
            Else
                MsgBox("Fill Required Field")
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub FieldClear()
        cmbGrnNumber.SelectedIndex = 0
        cmbPaymentType.SelectedIndex = 0
        txtAmount.Text = ""
        txtPaiedAmount.Text = ""
        txtRemark.Text = ""
        txtTotalAmount.Text = ""
        txtTransactionNo.Text = ""
        txtPendingAmount.Text = ""
        txtSuplierName.Text = ""
    End Sub
    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub cmbPaymentType_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbPaymentType.SelectedIndexChanged
        If cmbPaymentType.SelectedIndex <> 0 Then
            txtTransactionNo.Enabled = True
        Else
            txtTransactionNo.Enabled = False
        End If

    End Sub
End Class